﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.Sql;
using System.Data.SqlClient;
using System.Text;
using InfoSoftGlobal;

public partial class DataProvider : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // Construct the connection string to interface with the SQL Server Database
        string connStr2 = @"Data Source=.\SQLEXPRESS;AttachDbFilename=C:\Users\Fusion Charts\Documents\Visual Studio 2010\WebSites\FusionChartsXT_with_ASPNET\App_Data\FusionChartsDB.mdf;Integrated Security=True;User Instance=True";

        // Initialize the string which would contain the chart data in XML format
        StringBuilder xmlStr_monthly_data = new StringBuilder();

        // Capture the year from the querystring
        String year = Request.QueryString["year"];

        // Provide the relevant customization attributes to the chart
        xmlStr_monthly_data.Append("<chart caption='Monthly Revenue for " + year + "' palette='3' showValues='0' numberPrefix='$' useRoundEdges='1'>");

        // Create a SQLConnection object 
        using (SqlConnection conn2 = new SqlConnection(connStr2))
        {
            // Establish the connection with the database
            conn2.Open();

            // Construct and execute SQL query which would return the total amount of the sales for each month of the year specified.
            SqlCommand query_monthly_data = new SqlCommand("SELECT SUM(FC_OrderDetails.UnitPrice * FC_OrderDetails.Quantity) AS AMOUNT, DATENAME(MONTH, FC_Orders.OrderDate) AS Month FROM FC_Orders INNER JOIN FC_OrderDetails ON FC_OrderDetails.OrderID = FC_Orders.OrderID WHERE YEAR(FC_Orders.OrderDate) = '" + year + "' GROUP BY MONTH(FC_Orders.OrderDate), DATENAME(MONTH, FC_Orders.OrderDate) ORDER BY MONTH(FC_Orders.OrderDate), DATENAME(MONTH, FC_Orders.OrderDate)", conn2);

            // Begin iterating through the result set
            SqlDataReader monthly_data = query_monthly_data.ExecuteReader();


            while (monthly_data.Read())
            {
                // Construct the chart data in XML format
                xmlStr_monthly_data.AppendFormat("<set label='{0}' value='{1}'/>", monthly_data["Month"].ToString(), monthly_data["AMOUNT"].ToString());
            }

            // End the XML string
            xmlStr_monthly_data.Append("</chart>");

            // Close the result set Reader object and the Connection object
            monthly_data.Close();
            conn2.Close();

            // Set the ContentType to "text/xml" and write the XML string in response
            Response.ContentType = "text/xml";
            Response.Write(xmlStr_monthly_data.ToString());
        }
    }
}