﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Data.Sql;
using System.Data.SqlClient;
using System.Text;
using InfoSoftGlobal;


public partial class Using_MS_SQL_Server : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // Create a blank array, and add each 'year' to it
        string[] year = new string[4];

        // To iterate through the array
        int i = 0;
 
        // Construct the connection string to interface with the SQL Server Database
        string connStr = @"Data Source=.\SQLEXPRESS;AttachDbFilename=C:\Users\Fusion Charts\Documents\Visual Studio 2010\WebSites\FusionChartsXT_with_ASPNET\App_Data\FusionChartsDB.mdf;Integrated Security=True;User Instance=True";

        // Initialize the string which would contain the chart data in XML format
        StringBuilder xmlStr = new StringBuilder();

        // Provide the relevant customization attributes to the chart
        xmlStr.Append("<chart caption='Total Revenue' palette='3' showValues='0' numberPrefix='$' useRoundEdges='1'>");

        // Create a SQLConnection object 
        using (SqlConnection conn = new SqlConnection(connStr))
        {
            // Establish the connection with the database
            conn.Open();

            // Construct and execute SQL query which would return the total revenue for each year
            SqlCommand query = new SqlCommand("SELECT SUM(FC_OrderDetails.UnitPrice * FC_OrderDetails.Quantity) AS AMOUNT, YEAR(FC_Orders.OrderDate) AS yr FROM FC_Orders INNER JOIN FC_OrderDetails ON FC_OrderDetails.OrderID = FC_Orders.OrderID GROUP BY YEAR(FC_Orders.OrderDate) ORDER BY YEAR(FC_Orders.OrderDate)", conn);

            // Begin iterating through the result set
            SqlDataReader rst = query.ExecuteReader();


            while (rst.Read())
            {
                // Accumulate the 'year' in the array. This will be useful later.
                year[i] = rst["yr"].ToString();

                // Construct the chart data in XML format, and provide the links to the child charts' data
                xmlStr.AppendFormat("<set label='{0}' value='{1}' link='newchart-xml-{2}'/>", rst["yr"].ToString(), rst["AMOUNT"].ToString(), rst["yr"].ToString());
                i++;
            }

            // Close the result set Reader object and the Connection object
            rst.Close();

            for(int j = 0; j < 3; j++) 
            {

                // Construct and execute SQL query which would return the total revenue for each month of the specified year
                SqlCommand linkedChartQuery = new SqlCommand("SELECT SUM(FC_OrderDetails.UnitPrice * FC_OrderDetails.Quantity) AS AMOUNT, DATENAME(MONTH, FC_Orders.OrderDate) AS Month FROM FC_Orders INNER JOIN FC_OrderDetails ON FC_OrderDetails.OrderID = FC_Orders.OrderID WHERE YEAR(FC_Orders.OrderDate) = '" + year[j] + "' GROUP BY MONTH(FC_Orders.OrderDate), DATENAME(MONTH, FC_Orders.OrderDate) ORDER BY MONTH(FC_Orders.OrderDate), DATENAME(MONTH, FC_Orders.OrderDate)", conn);

                // Begin iterating through the result set
                SqlDataReader linkedChartRst = linkedChartQuery.ExecuteReader();

                // Specify the ID for each child chart
                xmlStr.AppendFormat("<linkeddata id='" + year[j] + "' >");

                // Construct the XML data for the child chart
                xmlStr.AppendFormat("<chart caption='Monthly Revenue for " + year[j] + "' palette='3' showValues='0' numberPrefix='$' useRoundEdges='1'>");
                while (linkedChartRst.Read())
                {
                    // Construct the chart data in XML format
                    xmlStr.AppendFormat("<set label='{0}' value='{1}'/>", linkedChartRst["Month"].ToString(), linkedChartRst["AMOUNT"].ToString());
                }

                // Terminate the child chart's data, as well as the 'linkeddata' attribute
                xmlStr.Append("</chart></linkeddata>");

                // Close the result set Reader object
                linkedChartRst.Close();
            }

            // Close the XML for the parent chart
            xmlStr.Append("</chart>");
            conn.Close();

            // Set the rendering mode to JavaScript, from the default Flash.
            FusionCharts.SetRenderer("javascript");

            // Call the RenderChart method, pass the correct parameters, and write the return value to the Literal tag
            chart_from_db.Text = FusionCharts.RenderChart(
                "FusionChartsXT/Column2D.swf", // Path to chart's SWF
                "", // Page which returns chart data. Leave blank when using Data String.
                xmlStr.ToString(), // String containing the chart data. Leave blank when using Data URL.
                "annual_revenue",   // Unique chart ID
                "640", "340",       // Width & Height of chart
                false,              // Disable Debug Mode
                true);              // Register with JavaScript object
        }
        
    }
}